/*
 * Decompiled with CFR 0.152.
 */
package dev.upcraft.datasync.content;

import dev.upcraft.datasync.DataSyncMod;
import dev.upcraft.datasync.content.DataRegistry;
import dev.upcraft.datasync.content.DataType;
import dev.upcraft.datasync.content.StoredDataHolder;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2960;

public class DataStore {
    private static final Map<UUID, Map<class_2960, StoredDataHolder<?>>> globalStore = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> StoredDataHolder<T> getPlayerLookup(UUID playerId, DataType<T> type) {
        Map<UUID, Map<class_2960, StoredDataHolder<?>>> map = globalStore;
        synchronized (map) {
            return globalStore.computeIfAbsent(playerId, key -> new HashMap()).computeIfAbsent(type.id(), id -> StoredDataHolder.load(type, playerId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> StoredDataHolder<T> getPlayerLookupEmpty(UUID playerId, DataType<T> type) {
        Map<UUID, Map<class_2960, StoredDataHolder<?>>> map = globalStore;
        synchronized (map) {
            return globalStore.computeIfAbsent(playerId, key -> new HashMap()).computeIfAbsent(type.id(), id -> StoredDataHolder.ofValue(type, playerId, null));
        }
    }

    public static <T> StoredDataHolder<T> lookup(UUID playerId, DataType<T> type, boolean forceRefresh) {
        StoredDataHolder<T> value = DataStore.getPlayerLookup(playerId, type);
        if (forceRefresh) {
            value.reload();
        }
        return value;
    }

    public static CompletableFuture<Void> refresh(UUID uuid, boolean force) {
        Instant startTime = Instant.now();
        return CompletableFuture.allOf((CompletableFuture[])DataRegistry.values().parallelStream().map(dataType -> DataStore.lookup(uuid, dataType, force).asFuture()).toArray(CompletableFuture[]::new)).thenRun(() -> {
            Instant stopTime = Instant.now();
            Duration duration = Duration.between(startTime, stopTime);
            DataSyncMod.LOGGER.info("Loaded {} player data objects (took {}s {}ms)", new Object[]{DataRegistry.size(), duration.toSeconds(), duration.toMillisPart()});
        });
    }

    public static <T> Optional<T> getCached(UUID playerId, DataType<T> type) {
        return Optional.ofNullable(DataStore.getPlayerLookupEmpty(playerId, type).value());
    }
}

